import { View, Text, FlatList, StyleSheet } from "react-native";
import React from "react";
import { useDispatch, useSelector } from "react-redux";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import ListViewSkeleton from "../../../src/skeletons/screens/Filter/ListViewSkeleton";
import FeatureCategories from "../../Home/FeatureCategories/FeatureCategories";
import RelatedItem from "../../Home/FeaturedProducts/ProductDetails/RelatedItem/RelatedItem";
import SingleListView from "./SingleListView";
import { getMoreSearchProducts } from "../../../redux/slices/searchProducts/searchProducts";
import useAuth from "../../../hooks/useAuth";
import CustomActiveIndicator from "../../../src/components/CustomLoader/CustomActiveIndicator";
import { memo } from "react";
import useLangTranslation from "../../../hooks/useLangTranslation";

const ListView = ({ searchContent }) => {
    const { trans } = useLangTranslation();
    const { searchProducts, loading, nextPageUrl, loadMore } = useSelector(
        (state) => state.searchProducts
    );
    const { access_token } = useAuth();
    const dispatch = useDispatch();
    const handleMoreData = () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            dispatch(getMoreSearchProducts({ access_token, URL: nextPageUrl }));
        }
        return () => {
            isMounted = false;
        };
    };
    const size = {
        contHeight: dpr(130),
        contWidth: dpr(130),
        imgHeight: dpr(45),
        imgWidth: dpr(50),
    };

    return (
        <>
            {loading ? (
                <ListViewSkeleton></ListViewSkeleton>
            ) : searchProducts?.length > 0 ? (
                <View>
                    <FlatList
                        keyboardShouldPersistTaps={"always"}
                        data={searchProducts}
                        keyExtractor={(_, i) => "key" + i}
                        renderItem={({ item }) => (
                            <SingleListView item={item} />
                        )}
                        showsVerticalScrollIndicator={false}
                        initialNumToRender={10}
                        windowSize={10}
                        onEndReachedThreshold={1}
                        onEndReached={handleMoreData}
                    />
                </View>
            ) : (
                <View>
                    <Text style={styles.itemsFound}>
                        0 {trans("items found for")} "{searchContent}"
                    </Text>
                    <FeatureCategories
                        headerText={"Top Categories"}
                        size={size}
                    />
                    <View style={styles.mt}>
                        <RelatedItem headerText={trans("Trending Items")} />
                    </View>
                </View>
            )}
            {loadMore && <CustomActiveIndicator />}
        </>
    );
};

export default memo(ListView);


const styles = StyleSheet.create({
    itemsFound: {
        textAlign: "center",
        marginVertical: dpr(50),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(18),
        color: "#2C2C2C",
    },
    mt: {
        marginTop: dpr(30),
    }
})